<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: admin_login.php");
    exit();
}
require_once 'db.php';

// Get general statistics
// Total Users
$users_query = "SELECT COUNT(*) as total FROM users";
$users_result = mysqli_query($conn, $users_query);
$total_users = mysqli_fetch_assoc($users_result)['total'];

// Deposits Statistics
$deposits_query = "SELECT 
    COUNT(*) as total,
    SUM(CASE WHEN status = 'processing' THEN 1 ELSE 0 END) as pending,
    SUM(CASE WHEN status = 'processed' THEN amount ELSE 0 END) as total_processed
    FROM deposits";
$deposits_result = mysqli_query($conn, $deposits_query);
$deposits_stats = mysqli_fetch_assoc($deposits_result);

// Withdrawals Statistics
$withdrawals_query = "SELECT 
    COUNT(*) as total,
    SUM(CASE WHEN status = 'processing' THEN 1 ELSE 0 END) as pending,
    SUM(CASE WHEN status = 'processed' THEN amount ELSE 0 END) as total_processed
    FROM withdrawals";
$withdrawals_result = mysqli_query($conn, $withdrawals_query);
$withdrawals_stats = mysqli_fetch_assoc($withdrawals_result);

// Investments Statistics
$investments_query = "SELECT 
    COUNT(*) as total,
    SUM(amount) as total_amount,
    SUM(CASE WHEN status = 'running' THEN 1 ELSE 0 END) as running,
    SUM(profit) as total_profit
    FROM investments";
$investments_result = mysqli_query($conn, $investments_query);
$investments_stats = mysqli_fetch_assoc($investments_result);

// Recent Activities
$recent_deposits = "SELECT d.*, u.phone_number 
    FROM deposits d 
    JOIN users u ON d.user_id = u.id 
    ORDER BY d.created_at DESC LIMIT 5";
$recent_deposits_result = mysqli_query($conn, $recent_deposits);

$recent_withdrawals = "SELECT w.*, u.phone_number 
    FROM withdrawals w 
    JOIN users u ON w.user_id = u.id 
    ORDER BY w.created_at DESC LIMIT 5";
$recent_withdrawals_result = mysqli_query($conn, $recent_withdrawals);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - MaxTrade</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            background-color: #0a0a0a;
            color: #fff;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 14px;
        }
        
        /* Header */
        .header {
            background: linear-gradient(135deg, #1a1a1a 0%, #000 100%);
            padding: 15px 20px;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.8);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        .header-left {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .menu-toggle {
            background: none;
            border: none;
            color: #FFD700;
            font-size: 24px;
            cursor: pointer;
            padding: 5px;
        }
        .header h1 {
            color: #FFD700;
            font-size: 20px;
            font-weight: 600;
        }
        .header-right {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .admin-info {
            text-align: right;
            font-size: 12px;
        }
        .admin-name {
            color: #FFD700;
            font-weight: bold;
        }
        .admin-role {
            color: #888;
            font-size: 11px;
        }
        .logout-btn {
            background: #f87171;
            color: #fff;
            padding: 8px 15px;
            border-radius: 5px;
            text-decoration: none;
            font-size: 13px;
            display: flex;
            align-items: center;
            gap: 5px;
            transition: background 0.3s;
        }
        .logout-btn:hover {
            background: #ef4444;
        }

        /* Sidebar */
        .sidebar {
            position: fixed;
            left: -280px;
            top: 0;
            width: 280px;
            height: 100vh;
            background: linear-gradient(180deg, #1a1a1a 0%, #0a0a0a 100%);
            box-shadow: 2px 0 20px rgba(0, 0, 0, 0.8);
            transition: left 0.3s ease;
            z-index: 999;
            overflow-y: auto;
            padding-top: 70px;
        }
        .sidebar.active {
            left: 0;
        }
        .sidebar-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            display: none;
            z-index: 998;
        }
        .sidebar-overlay.active {
            display: block;
        }
        .nav-section {
            padding: 20px;
        }
        .nav-title {
            color: #888;
            font-size: 11px;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 10px;
            font-weight: 600;
        }
        .nav-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 15px;
            color: #fff;
            text-decoration: none;
            border-radius: 8px;
            margin-bottom: 5px;
            transition: all 0.3s;
            font-size: 14px;
        }
        .nav-item:hover {
            background: rgba(255, 215, 0, 0.1);
            color: #FFD700;
            transform: translateX(5px);
        }
        .nav-item.active {
            background: #FFD700;
            color: #000;
        }
        .nav-item i {
            width: 20px;
            text-align: center;
        }

        /* Main Content */
        .main-content {
            margin-top: 70px;
            padding: 20px;
            max-width: 1400px;
            margin-left: auto;
            margin-right: auto;
        }

        /* Welcome Banner */
        .welcome-banner {
            background: linear-gradient(135deg, #FFD700 0%, #FFA500 100%);
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 25px;
            color: #000;
            box-shadow: 0 8px 25px rgba(255, 215, 0, 0.3);
        }
        .welcome-banner h2 {
            font-size: 24px;
            margin-bottom: 5px;
        }
        .welcome-banner p {
            font-size: 13px;
            opacity: 0.8;
        }

        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 25px;
        }
        .stat-card {
            background: linear-gradient(135deg, #1a1a1a 0%, #0f0f0f 100%);
            border-radius: 15px;
            padding: 20px;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.5);
            border: 1px solid #222;
            transition: all 0.3s;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 35px rgba(0, 0, 0, 0.7);
            border-color: #FFD700;
        }
        .stat-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 15px;
        }
        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }
        .stat-card.users .stat-icon {
            background: rgba(59, 130, 246, 0.2);
            color: #3b82f6;
        }
        .stat-card.deposits .stat-icon {
            background: rgba(34, 197, 94, 0.2);
            color: #22c55e;
        }
        .stat-card.withdrawals .stat-icon {
            background: rgba(239, 68, 68, 0.2);
            color: #ef4444;
        }
        .stat-card.investments .stat-icon {
            background: rgba(168, 85, 247, 0.2);
            color: #a855f7;
        }
        .stat-title {
            color: #888;
            font-size: 12px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        .stat-number {
            font-size: 32px;
            font-weight: bold;
            color: #fff;
            margin-bottom: 8px;
        }
        .stat-card.users .stat-number { color: #3b82f6; }
        .stat-card.deposits .stat-number { color: #22c55e; }
        .stat-card.withdrawals .stat-number { color: #ef4444; }
        .stat-card.investments .stat-number { color: #a855f7; }
        
        .stat-details {
            display: flex;
            gap: 15px;
            font-size: 12px;
            color: #888;
        }
        .stat-detail {
            display: flex;
            flex-direction: column;
        }
        .stat-detail-value {
            color: #fff;
            font-weight: 600;
        }

        /* Quick Actions */
        .quick-actions {
            margin-bottom: 25px;
        }
        .section-title {
            color: #FFD700;
            font-size: 18px;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .actions-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }
        .action-btn {
            background: linear-gradient(135deg, #1a1a1a 0%, #0f0f0f 100%);
            border: 1px solid #222;
            border-radius: 12px;
            padding: 20px;
            text-decoration: none;
            color: #fff;
            display: flex;
            align-items: center;
            gap: 15px;
            transition: all 0.3s;
        }
        .action-btn:hover {
            transform: translateY(-3px);
            border-color: #FFD700;
            box-shadow: 0 8px 20px rgba(255, 215, 0, 0.2);
        }
        .action-icon {
            width: 45px;
            height: 45px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            background: rgba(255, 215, 0, 0.1);
            color: #FFD700;
        }
        .action-text {
            flex: 1;
        }
        .action-title {
            font-weight: 600;
            margin-bottom: 3px;
        }
        .action-desc {
            font-size: 11px;
            color: #888;
        }

        /* Recent Activities */
        .activities-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
            gap: 20px;
            margin-bottom: 25px;
        }
        .activity-card {
            background: linear-gradient(135deg, #1a1a1a 0%, #0f0f0f 100%);
            border-radius: 15px;
            padding: 20px;
            border: 1px solid #222;
        }
        .activity-item {
            padding: 12px;
            background: #0a0a0a;
            border-radius: 8px;
            margin-bottom: 10px;
            border-left: 3px solid #333;
            transition: all 0.3s;
        }
        .activity-item:hover {
            border-left-color: #FFD700;
            background: #111;
        }
        .activity-item:last-child {
            margin-bottom: 0;
        }
        .activity-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 5px;
        }
        .activity-amount {
            font-weight: bold;
            color: #FFD700;
        }
        .activity-status {
            padding: 3px 8px;
            border-radius: 4px;
            font-size: 10px;
            font-weight: bold;
        }
        .status-processing {
            background: #FFA500;
            color: #000;
        }
        .status-processed {
            background: #22c55e;
            color: #000;
        }
        .activity-info {
            font-size: 12px;
            color: #888;
        }
        .no-activity {
            text-align: center;
            padding: 30px;
            color: #666;
        }

        @media (max-width: 768px) {
            .stats-grid {
                grid-template-columns: 1fr;
            }
            .activities-grid {
                grid-template-columns: 1fr;
            }
            .actions-grid {
                grid-template-columns: 1fr;
            }
            .admin-info {
                display: none;
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <div class="header-left">
            <button class="menu-toggle" onclick="toggleSidebar()">
                <i class="fas fa-bars"></i>
            </button>
            <h1><i class="fas fa-crown"></i> MaxTrade Admin</h1>
        </div>
        <div class="header-right">
            <div class="admin-info">
                <div class="admin-name">Administrator</div>
                <div class="admin-role">Super Admin</div>
            </div>
            <a href="admin_logout.php" class="logout-btn">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="sidebar-overlay" onclick="toggleSidebar()"></div>
    <div class="sidebar">
        <div class="nav-section">
            <div class="nav-title">Main Menu</div>
            <a href="admin_dashboard.php" class="nav-item active">
                <i class="fas fa-chart-line"></i>
                <span>Dashboard</span>
            </a>
            <a href="admin_users.php" class="nav-item">
                <i class="fas fa-users"></i>
                <span>Manage Users</span>
            </a>
        </div>

        <div class="nav-section">
            <div class="nav-title">Transactions</div>
            <a href="admin_deposits.php" class="nav-item">
                <i class="fas fa-money-bill-wave"></i>
                <span>Deposits</span>
            </a>
            <a href="admin_withdrawals.php" class="nav-item">
                <i class="fas fa-hand-holding-usd"></i>
                <span>Withdrawals</span>
            </a>
        </div>

        <div class="nav-section">
            <div class="nav-title">Investment</div>
            <a href="admin_investments.php" class="nav-item">
                <i class="fas fa-chart-pie"></i>
                <span>Investments</span>
            </a>
            <a href="admin_profits.php" class="nav-item">
                <i class="fas fa-coins"></i>
                <span>Profits</span>
            </a>
            <a href="admin_plans.php" class="nav-item">
                <i class="fas fa-clipboard-list"></i>
                <span>Investment Plans</span>
            </a>
        </div>

        <div class="nav-section">
            <div class="nav-title">Referrals</div>
            <a href="admin_referral_commission.php" class="nav-item">
                <i class="fas fa-percentage"></i>
                <span>Referral Commission</span>
            </a>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Welcome Banner -->
        <div class="welcome-banner">
            <h2><i class="fas fa-hand-sparkles"></i> Welcome Back, Admin!</h2>
            <p>Here's what's happening with MaxTrade today</p>
        </div>

        <!-- Statistics Grid -->
        <div class="stats-grid">
            <!-- Users Stats -->
            <div class="stat-card users">
                <div class="stat-header">
                    <div class="stat-title">Total Users</div>
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                </div>
                <div class="stat-number"><?php echo number_format($total_users); ?></div>
                <div class="stat-details">
                    <div class="stat-detail">
                        <span>Registered</span>
                        <span class="stat-detail-value"><?php echo number_format($total_users); ?></span>
                    </div>
                </div>
            </div>

            <!-- Deposits Stats -->
            <div class="stat-card deposits">
                <div class="stat-header">
                    <div class="stat-title">Deposits</div>
                    <div class="stat-icon">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                </div>
                <div class="stat-number">$<?php echo number_format($deposits_stats['total_processed'], 2); ?></div>
                <div class="stat-details">
                    <div class="stat-detail">
                        <span>Pending</span>
                        <span class="stat-detail-value"><?php echo $deposits_stats['pending']; ?></span>
                    </div>
                    <div class="stat-detail">
                        <span>Total</span>
                        <span class="stat-detail-value"><?php echo $deposits_stats['total']; ?></span>
                    </div>
                </div>
            </div>

            <!-- Withdrawals Stats -->
            <div class="stat-card withdrawals">
                <div class="stat-header">
                    <div class="stat-title">Withdrawals</div>
                    <div class="stat-icon">
                        <i class="fas fa-hand-holding-usd"></i>
                    </div>
                </div>
                <div class="stat-number">$<?php echo number_format($withdrawals_stats['total_processed'], 2); ?></div>
                <div class="stat-details">
                    <div class="stat-detail">
                        <span>Pending</span>
                        <span class="stat-detail-value"><?php echo $withdrawals_stats['pending']; ?></span>
                    </div>
                    <div class="stat-detail">
                        <span>Total</span>
                        <span class="stat-detail-value"><?php echo $withdrawals_stats['total']; ?></span>
                    </div>
                </div>
            </div>

            <!-- Investments Stats -->
            <div class="stat-card investments">
                <div class="stat-header">
                    <div class="stat-title">Investments</div>
                    <div class="stat-icon">
                        <i class="fas fa-chart-pie"></i>
                    </div>
                </div>
                <div class="stat-number">$<?php echo number_format($investments_stats['total_amount'], 2); ?></div>
                <div class="stat-details">
                    <div class="stat-detail">
                        <span>Active</span>
                        <span class="stat-detail-value"><?php echo $investments_stats['running']; ?></span>
                    </div>
                    <div class="stat-detail">
                        <span>Profit</span>
                        <span class="stat-detail-value">$<?php echo number_format($investments_stats['total_profit'], 2); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="quick-actions">
            <div class="section-title">
                <i class="fas fa-bolt"></i>
                Quick Actions
            </div>
            <div class="actions-grid">
                <a href="admin_users.php" class="action-btn">
                    <div class="action-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="action-text">
                        <div class="action-title">Manage Users</div>
                        <div class="action-desc">View and manage users</div>
                    </div>
                </a>
                <a href="admin_deposits.php" class="action-btn">
                    <div class="action-icon">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <div class="action-text">
                        <div class="action-title">Deposits</div>
                        <div class="action-desc">Approve/Reject deposits</div>
                    </div>
                </a>
                <a href="admin_withdrawals.php" class="action-btn">
                    <div class="action-icon">
                        <i class="fas fa-hand-holding-usd"></i>
                    </div>
                    <div class="action-text">
                        <div class="action-title">Withdrawals</div>
                        <div class="action-desc">Process withdrawals</div>
                    </div>
                </a>
                <a href="admin_plans.php" class="action-btn">
                    <div class="action-icon">
                        <i class="fas fa-clipboard-list"></i>
                    </div>
                    <div class="action-text">
                        <div class="action-title">Plans</div>
                        <div class="action-desc">Manage investment plans</div>
                    </div>
                </a>
            </div>
        </div>

        <!-- Recent Activities -->
        <div class="section-title">
            <i class="fas fa-history"></i>
            Recent Activities
        </div>
        <div class="activities-grid">
            <!-- Recent Deposits -->
            <div class="activity-card">
                <h3 style="color: #22c55e; margin-bottom: 15px; font-size: 16px;">
                    <i class="fas fa-arrow-down"></i> Recent Deposits
                </h3>
                <?php if ($recent_deposits_result && mysqli_num_rows($recent_deposits_result) > 0): ?>
                    <?php while ($deposit = mysqli_fetch_assoc($recent_deposits_result)): ?>
                    <div class="activity-item">
                        <div class="activity-header">
                            <div class="activity-amount">
                                $<?php echo number_format($deposit['amount'], 2); ?>
                            </div>
                            <span class="activity-status status-<?php echo $deposit['status']; ?>">
                                <?php echo strtoupper($deposit['status']); ?>
                            </span>
                        </div>
                        <div class="activity-info">
                            <i class="fas fa-user"></i> <?php echo htmlspecialchars($deposit['phone_number']); ?>
                            | <i class="fas fa-clock"></i> <?php echo date('M d, h:i A', strtotime($deposit['created_at'])); ?>
                        </div>
                    </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div class="no-activity">
                        <i class="fas fa-inbox" style="font-size: 30px; opacity: 0.3;"></i>
                        <p>No recent deposits</p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Recent Withdrawals -->
            <div class="activity-card">
                <h3 style="color: #ef4444; margin-bottom: 15px; font-size: 16px;">
                    <i class="fas fa-arrow-up"></i> Recent Withdrawals
                </h3>
                <?php if ($recent_withdrawals_result && mysqli_num_rows($recent_withdrawals_result) > 0): ?>
                    <?php while ($withdrawal = mysqli_fetch_assoc($recent_withdrawals_result)): ?>
                    <div class="activity-item">
                        <div class="activity-header">
                            <div class="activity-amount">
                                $<?php echo number_format($withdrawal['amount'], 2); ?>
                            </div>
                            <span class="activity-status status-<?php echo $withdrawal['status']; ?>">
                                <?php echo strtoupper($withdrawal['status']); ?>
                            </span>
                        </div>
                        <div class="activity-info">
                            <i class="fas fa-user"></i> <?php echo htmlspecialchars($withdrawal['phone_number']); ?>
                            | <i class="fas fa-clock"></i> <?php echo date('M d, h:i A', strtotime($withdrawal['created_at'])); ?>
                        </div>
                    </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div class="no-activity">
                        <i class="fas fa-inbox" style="font-size: 30px; opacity: 0.3;"></i>
                        <p>No recent withdrawals</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
        function toggleSidebar() {
            const sidebar = document.querySelector('.sidebar');
            const overlay = document.querySelector('.sidebar-overlay');
            sidebar.classList.toggle('active');
            overlay.classList.toggle('active');
        }

        // Close sidebar when clicking outside on mobile
        window.addEventListener('resize', function() {
            if (window.innerWidth > 768) {
                document.querySelector('.sidebar').classList.remove('active');
                document.querySelector('.sidebar-overlay').classList.remove('active');
            }
        });
    </script>
</body>
</html>
<?php
mysqli_close($conn);
?>