<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
require_once 'db.php';
require_once 'email_helper.php';

$user_id = $_SESSION['user_id'];

$payment_details = [
    'method'  => 'Airtel Money',
    'number'  => '0775886917',
    'name'    => 'SYDNEY SIKAZWE',
];

// ── PRG: read flash messages set by previous POST ────────────────────────────
$success = $_SESSION['deposit_success'] ?? null;
$error   = $_SESSION['deposit_error']   ?? null;
unset($_SESSION['deposit_success'], $_SESSION['deposit_error']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $amount = floatval($_POST['amount']);

    if ($amount < 100) {
        $_SESSION['deposit_error'] = "Minimum deposit amount is ZMW 100";
    } else {
        if (isset($_FILES['screenshot']) && $_FILES['screenshot']['error'] == 0) {
            $upload_dir = 'uploads/deposits/';
            if (!file_exists($upload_dir)) mkdir($upload_dir, 0777, true);

            $allowed_types = ['jpg','jpeg','png','gif'];
            $file_ext      = strtolower(pathinfo($_FILES['screenshot']['name'], PATHINFO_EXTENSION));
            $file_size     = $_FILES['screenshot']['size'];

            if (!in_array($file_ext, $allowed_types)) {
                $_SESSION['deposit_error'] = "Only JPG, JPEG, PNG & GIF files are allowed";
            } elseif ($file_size > 5 * 1024 * 1024) {
                $_SESSION['deposit_error'] = "File too large. Maximum 5MB";
            } elseif (!getimagesize($_FILES['screenshot']['tmp_name'])) {
                $_SESSION['deposit_error'] = "Not a valid image";
            } else {
                $screenshot = $upload_dir . 'deposit_' . $user_id . '_' . time() . '.' . $file_ext;

                if (move_uploaded_file($_FILES['screenshot']['tmp_name'], $screenshot)) {
                    $sql  = "INSERT INTO deposits (user_id, amount, screenshot, status, created_at) VALUES (?, ?, ?, 'processing', NOW())";
                    $stmt = mysqli_prepare($conn, $sql);

                    if ($stmt) {
                        mysqli_stmt_bind_param($stmt, "ids", $user_id, $amount, $screenshot);

                        if (mysqli_stmt_execute($stmt)) {
                            $_SESSION['deposit_success'] = "Deposit submitted! Your balance will be credited within 1 minute after verification.";

                            // Email notification
                            $eq = mysqli_prepare($conn, "SELECT email FROM users WHERE id=?");
                            mysqli_stmt_bind_param($eq, "i", $user_id);
                            mysqli_stmt_execute($eq);
                            $udat = mysqli_fetch_assoc(mysqli_stmt_get_result($eq));
                            mysqli_stmt_close($eq);
                            if (!empty($udat['email'])) sendDepositNotification($udat['email'], $amount, 'processing');

                        } else {
                            $_SESSION['deposit_error'] = "Failed to submit deposit: " . mysqli_error($conn);
                            if (file_exists($screenshot)) unlink($screenshot);
                        }
                        mysqli_stmt_close($stmt);
                    } else {
                        $_SESSION['deposit_error'] = "Database error: " . mysqli_error($conn);
                    }
                } else {
                    $_SESSION['deposit_error'] = "Failed to upload screenshot";
                }
            }
        } else {
            $_SESSION['deposit_error'] = "Please upload payment screenshot";
        }
    }

    // PRG – redirect back to GET so refresh won't re-submit
    header("Location: " . $_SERVER['PHP_SELF']);
    exit();
}

// ── History ──────────────────────────────────────────────────────────────────
$history_result = null;
$stmt = mysqli_prepare($conn, "SELECT * FROM deposits WHERE user_id=? ORDER BY created_at DESC LIMIT 6");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, "i", $user_id);
    mysqli_stmt_execute($stmt);
    $history_result = mysqli_stmt_get_result($stmt);
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Deposit - MaxTrade</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<style>
* { margin:0; padding:0; box-sizing:border-box; }

body {
    background:#0a0a0a;
    color:#fff;
    font-family:Arial,sans-serif;
    padding-bottom:80px;
    font-size:13px;
}

/* HEADER */
.header {
    background:#111;
    padding:11px 14px;
    display:flex; align-items:center; gap:12px;
    border-bottom:1px solid #1e1e1e;
    position:sticky; top:0; z-index:100;
}
.back-btn { color:#00c853; font-size:18px; text-decoration:none; }
.header h1 { font-size:15px; font-weight:700; }

/* ALERTS */
.alert {
    margin:10px 12px 0;
    padding:10px 14px;
    border-radius:8px;
    font-size:12px;
    display:flex; align-items:flex-start; gap:8px;
}
.alert-success { background:#0d2e0d; border:1px solid #1a5c1a; color:#4ade80; }
.alert-error   { background:#2e0d0d; border:1px solid #5c1a1a; color:#f87171; }

/* CLOSED BANNER */
.closed-banner {
    margin:10px 12px 0;
    background:rgba(255,60,0,0.1);
    border:1px solid rgba(255,60,0,0.35);
    border-radius:10px;
    padding:12px 14px;
    display:flex; align-items:center; gap:10px;
    font-size:12px; color:#ff6633;
}
.closed-banner i { font-size:20px; flex-shrink:0; }
.closed-banner strong { color:#ff3c00; }

.wrap { padding:12px; }

/* INFO BANNER */
.info-banner {
    display:grid; grid-template-columns:1fr 1fr;
    gap:8px; margin-bottom:12px;
}
.info-box {
    background:#111;
    border:1px solid #1e1e1e;
    border-radius:10px;
    padding:11px 8px;
    text-align:center;
}
.info-box.hl { border-color:rgba(0,200,83,0.35); background:rgba(0,200,83,0.05); }
.ib-icon  { font-size:15px; margin-bottom:4px; color:#00c853; }
.ib-val   { font-size:14px; font-weight:800; color:#fff; }
.ib-lbl   { font-size:9px; color:#555; margin-top:2px; }

/* SERVICE HOURS BOX */
.hours-box {
    background:#111;
    border:1px solid #1e1e1e;
    border-radius:10px;
    padding:10px 12px;
    margin-bottom:12px;
    display:flex; align-items:center; justify-content:space-between;
    font-size:11px;
}
.hours-box .h-label { color:#555; }
.hours-box .h-time  { font-weight:800; color:#fff; }
.hours-box .h-tz    { font-size:9px; color:#444; }
.status-dot {
    width:8px; height:8px; border-radius:50%;
    display:inline-block; margin-right:5px;
}
.dot-open   { background:#00c853; box-shadow:0 0 5px #00c853; }
.dot-closed { background:#f87171; box-shadow:0 0 5px #f87171; }

/* ANIMATIONS */
@keyframes airtel-glow {
    0%,100% { box-shadow:0 4px 20px rgba(255,60,0,0.08), 0 0 0 0 rgba(255,60,0,0); border-color:rgba(255,60,0,0.35); }
    50%      { box-shadow:0 6px 30px rgba(255,60,0,0.25), 0 0 18px 4px rgba(255,60,0,0.15); border-color:rgba(255,60,0,0.7); }
}
@keyframes mtn-glow {
    0%,100% { box-shadow:0 4px 20px rgba(255,204,0,0.08), 0 0 0 0 rgba(255,204,0,0); border-color:rgba(255,204,0,0.35); }
    50%      { box-shadow:0 6px 30px rgba(255,204,0,0.28), 0 0 18px 4px rgba(255,204,0,0.18); border-color:rgba(255,204,0,0.75); }
}
@keyframes pulse-icon {
    0%,100% { transform:scale(1); }
    50%      { transform:scale(1.15); }
}
.airtel-card { animation: airtel-glow 2.4s ease-in-out infinite; }
.mtn-card    { animation: mtn-glow   2.4s ease-in-out infinite 1.2s; }
.airtel-logo-icon { animation: pulse-icon 2.4s ease-in-out infinite; }
.mtn-logo-icon    { animation: pulse-icon 2.4s ease-in-out infinite 1.2s; }

/* METHOD TAGS in steps */
.method-tag {
    display:inline-flex; align-items:center; gap:3px;
    padding:2px 7px; border-radius:4px;
    font-size:9px; font-weight:700;
    margin:2px 2px 0; vertical-align:middle;
}
.method-tag small { font-weight:400; font-size:8px; opacity:0.85; }
.airtel-tag { background:rgba(255,60,0,0.18); color:#ff6633; border:1px solid rgba(255,60,0,0.3); }
.mtn-tag    { background:rgba(255,204,0,0.18); color:#ffcc00; border:1px solid rgba(255,204,0,0.3); }

/* PAYMENT GRID */
.payment-grid {
    display:grid;
    grid-template-columns:1fr 1fr;
    gap:10px;
    margin-bottom:12px;
}
.pay-card {
    margin-bottom:0 !important;
    padding:12px !important;
}
.pay-card-header {
    display:flex; align-items:center; gap:8px;
    margin-bottom:10px;
}
.pay-card-sub { font-size:8px; color:#555; margin-top:1px; }
.pay-row {
    background:rgba(0,0,0,0.4);
    border:1px solid rgba(255,255,255,0.06);
    border-radius:6px;
    padding:7px 8px;
    margin-bottom:6px;
}
.pay-row:last-child { margin-bottom:0; }
.pay-label { font-size:9px; color:#555; margin-bottom:3px; }
.pay-label.mtn-label { color:#9a8000; }
.pay-val-row { display:flex; align-items:center; justify-content:space-between; gap:4px; }
.pay-val { font-size:11px; font-weight:700; color:#fff; word-break:break-all; }
.copy-btn { background:rgba(255,60,0,0.12); border:1px solid rgba(255,60,0,0.25); color:#ff6633; padding:4px 7px; border-radius:5px; cursor:pointer; font-size:10px; flex-shrink:0; }
.copy-btn:hover { background:rgba(255,60,0,0.22); }
.mtn-copy-btn { background:rgba(255,204,0,0.12); border:1px solid rgba(255,204,0,0.25); color:#ffcc00; padding:4px 7px; border-radius:5px; cursor:pointer; font-size:10px; flex-shrink:0; }
.mtn-copy-btn:hover { background:rgba(255,204,0,0.22); }

/* AIRTEL PAYMENT CARD */
.airtel-card {
    background: linear-gradient(135deg, #1a0a00 0%, #3d1a00 50%, #1a0a00 100%);
    border:1px solid rgba(255,60,0,0.35);
    border-radius:12px;
    padding:16px;
    margin-bottom:12px;
    box-shadow:0 4px 20px rgba(255,60,0,0.08);
    position:relative;
    overflow:hidden;
}
.airtel-card::before {
    content:'';
    position:absolute; top:-30px; right:-30px;
    width:100px; height:100px;
    background:rgba(255,60,0,0.05);
    border-radius:50%;
}
.airtel-logo-row {
    display:flex; align-items:center; gap:10px;
    margin-bottom:14px;
}
.airtel-logo-icon {
    width:38px; height:38px;
    background:rgba(255,60,0,0.15);
    border:1px solid rgba(255,60,0,0.3);
    border-radius:10px;
    display:flex; align-items:center; justify-content:center;
    font-size:18px; color:#ff3c00;
}
.airtel-logo-text { font-size:14px; font-weight:800; color:#ff3c00; }
.airtel-logo-sub  { font-size:9px; color:#555; margin-top:1px; }

.detail-row {
    background:rgba(0,0,0,0.4);
    border:1px solid rgba(255,255,255,0.06);
    border-radius:8px;
    padding:10px 12px;
    margin-bottom:8px;
    display:flex; align-items:center; justify-content:space-between;
}
.detail-row:last-child { margin-bottom:0; }
.dl-left { display:flex; align-items:center; gap:8px; }
.dl-icon  { font-size:12px; color:#ff3c00; width:18px; text-align:center; }
.dl-label { font-size:9px; color:#555; margin-bottom:2px; }
.dl-value { font-size:13px; font-weight:700; color:#fff; letter-spacing:0.5px; }
.copy-btn {
    background:rgba(255,60,0,0.12);
    border:1px solid rgba(255,60,0,0.25);
    color:#ff6633;
    padding:6px 10px;
    border-radius:6px;
    cursor:pointer;
    font-size:11px;
    white-space:nowrap;
}
.copy-btn:hover { background:rgba(255,60,0,0.22); }

/* MTN PAYMENT CARD */
.mtn-card {
    background: linear-gradient(135deg, #1a1400 0%, #3d3000 50%, #1a1400 100%);
    border:1px solid rgba(255,204,0,0.35);
    border-radius:12px;
    padding:16px;
    margin-bottom:12px;
    box-shadow:0 4px 20px rgba(255,204,0,0.08);
    position:relative;
    overflow:hidden;
}
.mtn-card::before {
    content:'';
    position:absolute; top:-30px; right:-30px;
    width:100px; height:100px;
    background:rgba(255,204,0,0.05);
    border-radius:50%;
}
.mtn-logo-icon {
    width:38px; height:38px;
    background:rgba(255,204,0,0.15);
    border:1px solid rgba(255,204,0,0.3);
    border-radius:10px;
    display:flex; align-items:center; justify-content:center;
    font-size:18px; color:#ffcc00;
}
.mtn-logo-text { font-size:14px; font-weight:800; color:#ffcc00; }
.mtn-detail-row { border-color:rgba(255,255,255,0.06); }
.mtn-copy-btn {
    background:rgba(255,204,0,0.12);
    border:1px solid rgba(255,204,0,0.25);
    color:#ffcc00;
    padding:6px 10px;
    border-radius:6px;
    cursor:pointer;
    font-size:11px;
    white-space:nowrap;
}
.mtn-copy-btn:hover { background:rgba(255,204,0,0.22); }

/* STEPS */
.steps-card {
    background:#111;
    border:1px solid #1e1e1e;
    border-radius:12px;
    padding:14px;
    margin-bottom:12px;
}
.steps-title {
    font-size:10px; font-weight:700;
    color:#00c853; letter-spacing:1px;
    text-transform:uppercase;
    margin-bottom:10px;
    display:flex; align-items:center; gap:5px;
}
.step {
    display:flex; gap:10px;
    margin-bottom:9px; font-size:11px;
}
.step:last-child { margin-bottom:0; }
.step-num {
    width:20px; height:20px;
    background:#00c853; color:#000;
    border-radius:50%;
    display:flex; align-items:center; justify-content:center;
    font-weight:800; font-size:10px; flex-shrink:0;
}
.step-txt { color:#aaa; line-height:1.5; }
.step-txt strong { color:#fff; }

/* FORM CARD */
.form-card {
    background:#111;
    border:1px solid #1e1e1e;
    border-radius:12px;
    padding:14px;
    margin-bottom:12px;
}
.form-title {
    font-size:10px; font-weight:700;
    color:#00c853; letter-spacing:1px;
    text-transform:uppercase;
    margin-bottom:12px;
    display:flex; align-items:center; gap:5px;
}
.form-group { margin-bottom:11px; }
.form-lbl {
    display:block; margin-bottom:5px;
    color:#555; font-size:10px; letter-spacing:0.5px;
}
input[type="number"] {
    width:100%; padding:11px 12px;
    background:#000; border:1px solid #222;
    border-radius:8px; color:#fff; font-size:14px;
    font-weight:600;
}
input[type="number"]:focus { outline:none; border-color:#00c853; }
.file-upload-area {
    width:100%;
    border:2px dashed #1e1e1e;
    border-radius:8px;
    padding:14px;
    text-align:center;
    cursor:pointer;
    transition:border-color 0.2s;
    position:relative;
    background:#000;
}
.file-upload-area:hover { border-color:#00c853; }
.file-upload-area input { position:absolute; opacity:0; inset:0; cursor:pointer; }
.file-upload-area i { font-size:20px; color:#333; margin-bottom:5px; display:block; }
.file-upload-area p { font-size:11px; color:#555; }
.file-upload-area small { font-size:9px; color:#333; }
.file-selected { border-color:#00c853; }
.file-selected i { color:#00c853; }
.file-selected p { color:#00c853; }

.submit-btn {
    width:100%; padding:12px;
    background:#00c853; color:#000;
    border:none; border-radius:9px;
    font-weight:800; cursor:pointer;
    font-size:14px; margin-top:4px;
    display:flex; align-items:center; justify-content:center; gap:8px;
    transition:background 0.2s;
}
.submit-btn:hover { background:#00a846; }
.submit-btn:disabled {
    background:#333; color:#666; cursor:not-allowed;
}

/* NOTE */
.note {
    background:rgba(0,200,83,0.05);
    border:1px solid rgba(0,200,83,0.15);
    border-radius:8px;
    padding:10px 12px;
    margin-top:10px;
    font-size:10px;
    color:#555;
    line-height:1.7;
}
.note i { color:#00c853; margin-right:4px; }

/* HISTORY */
.history-card {
    background:#111;
    border:1px solid #1e1e1e;
    border-radius:12px;
    padding:14px;
}
.history-title {
    font-size:10px; font-weight:700;
    color:#00c853; letter-spacing:1px;
    text-transform:uppercase;
    margin-bottom:10px;
    display:flex; align-items:center; gap:5px;
}
.h-item {
    background:#000;
    border-radius:8px;
    padding:10px 12px;
    margin-bottom:7px;
    border-left:3px solid #222;
    display:flex; align-items:center; justify-content:space-between;
}
.h-item:last-child { margin-bottom:0; }
.h-item.processing { border-left-color:#FFA500; }
.h-item.processed  { border-left-color:#00c853; }
.h-item.rejected   { border-left-color:#f87171; }
.h-amount { font-weight:800; color:#fff; font-size:13px; }
.h-date   { font-size:9px; color:#444; margin-top:2px; }
.h-badge  {
    font-size:9px; font-weight:700;
    padding:3px 8px; border-radius:4px;
}
.b-processing { background:rgba(255,165,0,0.15); color:#FFA500; }
.b-processed  { background:rgba(0,200,83,0.15);  color:#00c853; }
.b-rejected   { background:rgba(248,113,113,0.15); color:#f87171; }
.no-history   { text-align:center; padding:18px; color:#333; font-size:11px; }
.no-history i { font-size:22px; display:block; margin-bottom:6px; }

/* disabled overlay on form */
.form-disabled { opacity:0.45; pointer-events:none; }
</style>
</head>
<body>

<div class="header">
    <a href="home.php" class="back-btn"><i class="fas fa-arrow-left"></i></a>
    <h1><i class="fas fa-wallet" style="color:#00c853;margin-right:6px;"></i>Make Deposit</h1>
</div>

<?php if ($success): ?>
<div class="alert alert-success"><i class="fas fa-check-circle" style="margin-top:1px;"></i><span><?php echo htmlspecialchars($success); ?></span></div>
<?php endif; ?>
<?php if ($error): ?>
<div class="alert alert-error"><i class="fas fa-exclamation-circle" style="margin-top:1px;"></i><span><?php echo htmlspecialchars($error); ?></span></div>
<?php endif; ?>

<div class="wrap">

    <!-- Info banner -->
    <div class="info-banner">
        <div class="info-box hl">
            <div class="ib-icon"><i class="fas fa-arrow-circle-down"></i></div>
            <div class="ib-val">ZMW 100</div>
            <div class="ib-lbl">Minimum Deposit</div>
        </div>
        <div class="info-box">
            <div class="ib-icon"><i class="fas fa-bolt"></i></div>
            <div class="ib-val">~1 Min</div>
            <div class="ib-lbl">Processing Time</div>
        </div>
    </div>

    <!-- Payment Methods Grid 2x2 -->
    <div class="payment-grid">

        <!-- Airtel Money -->
        <div class="airtel-card pay-card">
            <div class="pay-card-header">
                <div class="airtel-logo-icon"><i class="fas fa-mobile-alt"></i></div>
                <div>
                    <div class="airtel-logo-text">Airtel Money</div>
                    <div class="pay-card-sub">Tap to copy</div>
                </div>
            </div>
            <div class="pay-row">
                <div class="pay-label"><i class="fas fa-phone"></i> Number</div>
                <div class="pay-val-row">
                    <span class="pay-val" id="airtel-number"><?php echo htmlspecialchars($payment_details['number']); ?></span>
                    <button class="copy-btn" onclick="copyText('airtel-number','Number')"><i class="fas fa-copy"></i></button>
                </div>
            </div>
            <div class="pay-row">
                <div class="pay-label"><i class="fas fa-user"></i> Name</div>
                <div class="pay-val-row">
                    <span class="pay-val" id="airtel-name"><?php echo htmlspecialchars($payment_details['name']); ?></span>
                    <button class="copy-btn" onclick="copyText('airtel-name','Name')"><i class="fas fa-copy"></i></button>
                </div>
            </div>
        </div>

        <!-- MTN Money -->
        <div class="mtn-card pay-card">
            <div class="pay-card-header">
                <div class="mtn-logo-icon"><i class="fas fa-mobile-alt"></i></div>
                <div>
                    <div class="mtn-logo-text">MTN Money</div>
                    <div class="pay-card-sub">Tap to copy</div>
                </div>
            </div>
            <div class="pay-row">
                <div class="pay-label mtn-label"><i class="fas fa-phone"></i> Number</div>
                <div class="pay-val-row">
                    <span class="pay-val" id="mtn-number">0765633956</span>
                    <button class="mtn-copy-btn" onclick="copyText('mtn-number','Number')"><i class="fas fa-copy"></i></button>
                </div>
            </div>
            <div class="pay-row">
                <div class="pay-label mtn-label"><i class="fas fa-user"></i> Name</div>
                <div class="pay-val-row">
                    <span class="pay-val" id="mtn-name">MIRRIUM</span>
                    <button class="mtn-copy-btn" onclick="copyText('mtn-name','Name')"><i class="fas fa-copy"></i></button>
                </div>
            </div>
        </div>

    </div>

    <!-- Steps -->
    <div class="steps-card">
        <div class="steps-title"><i class="fas fa-list-ol"></i> How to Deposit</div>
        <div class="step">
            <div class="step-num">1</div>
            <div class="step-txt">Choose a payment method:
                <span class="method-tag airtel-tag">Airtel <small>0775886917</small></span>
                <span class="method-tag mtn-tag">MTN <small>0765633956</small></span>
            </div>
        </div>
        <div class="step">
            <div class="step-num">2</div>
            <div class="step-txt">Send money via <strong>Airtel Money</strong> or <strong>MTN Money</strong> to the number above</div>
        </div>
        <div class="step">
            <div class="step-num">3</div>
            <div class="step-txt">Take a <strong>screenshot</strong> of the confirmation message from your app</div>
        </div>
        <div class="step">
            <div class="step-num">4</div>
            <div class="step-txt">Enter the amount and upload your screenshot below</div>
        </div>
        <div class="step">
            <div class="step-num">5</div>
            <div class="step-txt">Your balance will be credited within <strong>~1 minute</strong> after verification</div>
        </div>
    </div>

    <!-- Form -->
    <div class="form-card">
        <div class="form-title"><i class="fas fa-upload"></i> Submit Deposit Proof</div>
        <form method="POST" enctype="multipart/form-data" id="depositForm" onsubmit="return handleSubmit(this)">
            <div class="form-group">
                <label class="form-lbl"><i class="fas fa-coins" style="margin-right:4px;color:#00c853;"></i>Amount (ZMW)</label>
                <input type="number" name="amount" step="0.01" min="100" placeholder="Minimum ZMW 100" required>
            </div>
            <div class="form-group">
                <label class="form-lbl"><i class="fas fa-image" style="margin-right:4px;color:#00c853;"></i>Payment Screenshot</label>
                <div class="file-upload-area" id="fileArea" onclick="document.getElementById('screenshotInput').click()">
                    <input type="file" name="screenshot" id="screenshotInput" accept="image/*" required onchange="fileSelected(this)">
                    <i class="fas fa-cloud-upload-alt" id="uploadIcon"></i>
                    <p id="fileText">Tap to upload screenshot</p>
                    <small>JPG, PNG, GIF — Max 5MB</small>
                </div>
            </div>
            <button type="submit" id="submitBtn" class="submit-btn">
                <i class="fas fa-paper-plane"></i> Submit Deposit Request
            </button>
        </form>
        <div class="note">
            <i class="fas fa-info-circle"></i>
            Minimum deposit is <strong style="color:#fff;">ZMW 100</strong>.
            Screenshot must clearly show the transaction reference.
            A confirmation email will be sent after approval.
        </div>
    </div>

    <!-- History -->
    <div class="history-card">
        <div class="history-title"><i class="fas fa-history"></i> Recent Deposits</div>
        <?php if ($history_result && mysqli_num_rows($history_result) > 0): ?>
            <?php while ($d = mysqli_fetch_assoc($history_result)): ?>
            <div class="h-item <?php echo htmlspecialchars($d['status']); ?>">
                <div>
                    <div class="h-amount">ZMW <?php echo number_format($d['amount'], 2); ?></div>
                    <div class="h-date"><i class="fas fa-clock" style="margin-right:3px;"></i><?php echo date('d M Y, h:i A', strtotime($d['created_at'])); ?></div>
                </div>
                <span class="h-badge b-<?php echo htmlspecialchars($d['status']); ?>">
                    <?php echo strtoupper($d['status']); ?>
                </span>
            </div>
            <?php endwhile; ?>
        <?php else: ?>
            <div class="no-history">
                <i class="fas fa-inbox"></i>
                No deposit history yet
            </div>
        <?php endif; ?>
    </div>

</div>

<script>
var submitting = false;

function handleSubmit(form) {
    if (submitting) return false; // block double-submit
    submitting = true;
    var btn = document.getElementById('submitBtn');
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Submitting…';
    return true;
}

function copyText(id, name) {
    const text = document.getElementById(id).textContent.trim();
    navigator.clipboard.writeText(text)
        .then(() => toast('✓ ' + name + ' copied!'))
        .catch(() => {
            const t = document.createElement('textarea');
            t.value = text; document.body.appendChild(t); t.select();
            document.execCommand('copy'); document.body.removeChild(t);
            toast('✓ ' + name + ' copied!');
        });
}
function fileSelected(input) {
    if (input.files && input.files[0]) {
        const area = document.getElementById('fileArea');
        area.classList.add('file-selected');
        document.getElementById('fileText').textContent = '✓ ' + input.files[0].name;
        document.getElementById('uploadIcon').className = 'fas fa-check-circle';
    }
}
function toast(msg) {
    const el = document.createElement('div');
    el.style.cssText = 'position:fixed;top:65px;left:50%;transform:translateX(-50%);background:#00c853;color:#000;padding:9px 18px;border-radius:20px;font-size:11px;font-weight:800;z-index:9999;';
    el.textContent = msg; document.body.appendChild(el);
    setTimeout(() => { el.style.transition='opacity .3s'; el.style.opacity='0'; setTimeout(()=>el.remove(),300); }, 2000);
}
setTimeout(() => {
    document.querySelectorAll('.alert').forEach(a => {
        a.style.transition='opacity .5s'; a.style.opacity='0';
        setTimeout(()=>a.remove(),500);
    });
}, 5000);
</script>
<?php include 'bottom-nav.php'; ?>
</body>
</html>
<?php if (isset($stmt)) mysqli_stmt_close($stmt); ?>