<?php
session_start();
require_once 'db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $login = mysqli_real_escape_string($conn, $_POST['login']);
    $password = $_POST['password'];
    
    $sql = "SELECT * FROM users WHERE phone_number='$login' OR email='$login'";
    $result = mysqli_query($conn, $sql);
    
    if (mysqli_num_rows($result) == 1) {
        $user = mysqli_fetch_assoc($result);
        if (password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            header("Location: home.php");
            exit();
        } else {
            $error = "Invalid password!";
        }
    } else {
        $error = "User not found!";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - MaxTrade</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            background-color: #000;
            color: #fff;
            font-family: Arial, sans-serif;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            width: 100%;
            max-width: 340px;
            padding: 25px;
            background: #111;
            border-radius: 8px;
            box-shadow: 0 0 15px rgba(255, 215, 0, 0.3);
        }
        .logo {
            text-align: center;
            margin-bottom: 15px;
        }
        .logo i {
            font-size: 40px;
            color: #FFD700;
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
            color: #fff;
            font-size: 22px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            color: #fff;
            font-size: 13px;
        }
        input {
            width: 100%;
            padding: 10px;
            background: #000;
            border: 1px solid #333;
            border-radius: 5px;
            color: #fff;
            font-size: 14px;
        }
        input:focus {
            outline: none;
            border-color: #FFD700;
        }
        button {
            width: 100%;
            padding: 11px;
            background: #FFD700;
            color: #000;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            margin-top: 8px;
            transition: background 0.3s;
        }
        button:hover {
            background: #FFA500;
        }
        .google-btn {
            background: #fff;
            color: #333;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            margin-top: 12px;
        }
        .google-btn:hover {
            background: #f0f0f0;
        }
        .google-btn img {
            width: 20px;
            height: 20px;
        }
        .error {
            background: #ff0000;
            color: #fff;
            padding: 8px;
            border-radius: 5px;
            margin-bottom: 12px;
            text-align: center;
            font-size: 13px;
        }
        .link {
            text-align: center;
            margin-top: 12px;
            font-size: 13px;
        }
        .link a {
            color: #FFD700;
            text-decoration: none;
        }
        .link a:hover {
            text-decoration: underline;
        }
        .forgot-link {
            text-align: right;
            margin-top: 8px;
            font-size: 12px;
        }
        .forgot-link a {
            color: #888;
        }
        .divider {
            text-align: center;
            margin: 15px 0;
            position: relative;
            color: #666;
            font-size: 12px;
        }
        .divider:before,
        .divider:after {
            content: '';
            position: absolute;
            top: 50%;
            width: 40%;
            height: 1px;
            background: #333;
        }
        .divider:before {
            left: 0;
        }
        .divider:after {
            right: 0;
        }

    </style>
</head>
<body>
    <div class="container">
        <div class="logo">
            <i class="fas fa-chart-line"></i>
        </div>
        <h2>Login</h2>
        
        <?php if (isset($error)): ?>
            <div class="error"><i class="fas fa-exclamation-circle"></i> <?php echo $error; ?></div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="form-group">
                <label><i class="fas fa-user"></i> Phone / Email</label>
                <input type="text" name="login" placeholder="Enter phone or email" required>
            </div>
            
            <div class="form-group">
                <label><i class="fas fa-lock"></i> Password</label>
                <input type="password" name="password" placeholder="Enter password" required>
            </div>
            
            <div class="forgot-link">
                <a href="forget_password.php">Forgot Password?</a>
            </div>
            
            <button type="submit">
                <i class="fas fa-sign-in-alt"></i> Login
            </button>
        </form>
        
        <div class="divider">OR</div>
        
        <button class="google-btn" onclick="window.location.href='google_login.php'">
            <img src="https://180mtm.site/google.png" alt="Google">
            Continue with Google
        </button>
        
        <div class="link">
            No account? <a href="register.php">Register</a>
        </div>
    </div>

</body>
</html>