<?php
session_start();
if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }
require_once 'db.php';
require_once 'credit_daily_profits.php';
include 'admin_indicator.php';

$user_id = intval($_SESSION['user_id']);

// Credit uncredited daily profits first
creditDailyProfits($conn, $user_id);

// ── Fetch user data ───────────────────────────────────────────────────────────
$urow = mysqli_fetch_assoc(mysqli_query($conn,
    "SELECT phone_number, balance FROM users WHERE id=$user_id"));
$phone           = $urow['phone_number'] ?? '';
$account_balance = floatval($urow['balance'] ?? 0);

// ─────────────────────────────────────────────────────────────────────────────
// CARD 2: RUNNING INVESTMENT (capital currently locked)
// ─────────────────────────────────────────────────────────────────────────────
$running_investments = floatval(mysqli_fetch_assoc(mysqli_query($conn,
    "SELECT COALESCE(SUM(amount),0) AS t FROM investments
     WHERE user_id=$user_id
       AND status IN ('running','active','')
       AND maturity_date > NOW()"))['t']);

$running_count = intval(mysqli_fetch_assoc(mysqli_query($conn,
    "SELECT COUNT(*) AS c FROM investments
     WHERE user_id=$user_id
       AND status IN ('running','active','')
       AND maturity_date > NOW()"))['c']);

// ─────────────────────────────────────────────────────────────────────────────
// CARD 4: DAILY PROFITS EARNED
// ─────────────────────────────────────────────────────────────────────────────
$daily_profits_earned = floatval(mysqli_fetch_assoc(mysqli_query($conn,
    "SELECT COALESCE(SUM(amount),0) AS t FROM daily_profit_credits
     WHERE user_id=$user_id AND type='daily_profit'"))['t']);

// ─────────────────────────────────────────────────────────────────────────────
// CARD 5: MATURED INVESTMENTS
// ─────────────────────────────────────────────────────────────────────────────
$matured_total = floatval(mysqli_fetch_assoc(mysqli_query($conn,
    "SELECT COALESCE(SUM(total_return),0) AS t FROM investments
     WHERE user_id=$user_id AND status='matured'"))['t']);

// ─────────────────────────────────────────────────────────────────────────────
// CARD 6: TOTAL WITHDRAWN
// ─────────────────────────────────────────────────────────────────────────────
$total_withdrawn = floatval(mysqli_fetch_assoc(mysqli_query($conn,
    "SELECT COALESCE(SUM(amount),0) AS t FROM withdrawals
     WHERE user_id=$user_id AND status='processed'"))['t']);

// Flash message
$flash = '';
if (isset($_SESSION['success_message'])) {
    $flash = $_SESSION['success_message'];
    unset($_SESSION['success_message']);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Home - MaxTrade</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<style>
*{margin:0;padding:0;box-sizing:border-box}
body{background:#0a0a0a;color:#fff;font-family:Arial,sans-serif;padding-bottom:85px;min-height:100vh}
.header{background:#111;padding:14px 16px;display:flex;align-items:center;justify-content:space-between;border-bottom:1px solid #1a1a1a}
.header-logo img{height:34px;width:auto}
.header-greeting{font-size:13px;color:#888}
.header-greeting span{color:#FFD700;font-weight:700}
.flash-banner{background:linear-gradient(135deg,#003d1a,#006b2e);border-left:4px solid #00e676;margin:12px 12px 0;padding:10px 14px;border-radius:8px;font-size:13px;color:#b9ffcf;display:flex;align-items:center;gap:8px}
.top-buttons{display:flex;gap:8px;padding:12px 12px 6px}
.top-btn{flex:1;padding:10px 4px;background:#141414;border:1px solid #222;border-radius:10px;text-align:center;text-decoration:none;color:#fff;font-size:10px;font-weight:600;transition:all .2s;display:flex;flex-direction:column;align-items:center;gap:5px}
.top-btn:hover{background:#1e1e1e;border-color:#FFD700;transform:translateY(-2px)}
.top-btn i{font-size:17px;color:#FFD700}
.top-btn span{color:#bbb}
.cards{padding:8px 12px 12px;display:flex;flex-direction:column;gap:10px}
.card{border-radius:16px;padding:16px 18px;position:relative;overflow:hidden}
.card.tap{cursor:pointer}
.card.tap:active{transform:scale(.99)}
.card-icon{width:30px;height:30px;border-radius:8px;display:flex;align-items:center;justify-content:center;margin-bottom:6px;font-size:13px}
.card-lbl{font-size:10px;font-weight:700;letter-spacing:1.5px;text-transform:uppercase;color:rgba(255,255,255,.5);margin-bottom:2px}
.card-amt{font-size:26px;font-weight:800;color:#fff;letter-spacing:-0.5px;line-height:1}
.card-cur{font-size:12px;font-weight:700;opacity:.8;vertical-align:top;margin-top:4px;display:inline-block;margin-right:2px}
.card-sub{font-size:10px;color:rgba(255,255,255,.28);margin-top:4px;line-height:1.4}
.card-badge{position:absolute;top:14px;right:14px;font-size:9px;font-weight:700;padding:3px 10px;border-radius:20px}
.c-balance{background:linear-gradient(135deg,#1a1200,#3d2e00);border:1px solid rgba(255,215,0,.3)}
.c-balance .card-icon{background:rgba(255,215,0,.12);color:#FFD700}
.c-balance .card-badge{background:rgba(255,215,0,.18);color:#FFD700}
.c-running{background:linear-gradient(135deg,#0d2e18,#1a5c30);border:1px solid rgba(0,230,118,.2)}
.c-running .card-icon{background:rgba(0,230,118,.12);color:#00e676}
.c-running .card-badge{background:rgba(0,230,118,.18);color:#00e676}
.c-daily{background:linear-gradient(135deg,#001a2e,#003366);border:1px solid rgba(0,180,255,.2)}
.c-daily .card-icon{background:rgba(0,180,255,.12);color:#00b4ff}
.c-daily .card-badge{background:rgba(0,180,255,.18);color:#00b4ff}
.c-matured{background:linear-gradient(135deg,#1e2800,#3d5200);border:1px solid rgba(180,230,0,.2)}
.c-matured .card-icon{background:rgba(180,230,0,.12);color:#c8e600}
.c-matured .card-badge{background:rgba(180,230,0,.18);color:#c8e600}
.c-withdrawn{background:linear-gradient(135deg,#2e0d0d,#5c1a1a);border:1px solid rgba(255,100,100,.2)}
.c-withdrawn .card-icon{background:rgba(255,100,100,.12);color:#ff6464}
.c-withdrawn .card-badge{background:rgba(255,100,100,.18);color:#ff6464}
.dot{width:7px;height:7px;border-radius:50%;display:inline-block;margin-right:4px;vertical-align:middle}
</style>
</head>
<body>

<div class="header">
    <div class="header-logo"><img src="https://pvp360.us/zambia/logoo.png" alt="MaxTrade"></div>
    <div class="header-greeting">Welcome, <span><?= htmlspecialchars(substr($phone,0,6)).'***' ?></span></div>
</div>

<?php if($flash): ?>
<div class="flash-banner"><i class="fas fa-check-circle"></i><?= htmlspecialchars($flash) ?></div>
<?php endif ?>

<div class="top-buttons">
    <a href="deposit.php"  class="top-btn"><i class="fas fa-wallet"></i><span>Deposit</span></a>
    <a href="withdraw.php" class="top-btn"><i class="fas fa-money-bill-wave"></i><span>Withdraw</span></a>
    <a href="plans.php"    class="top-btn"><i class="fas fa-seedling"></i><span>Invest</span></a>
    <a href="profits.php"  class="top-btn"><i class="fas fa-chart-line"></i><span>Profits</span></a>
    <a href="https://tawk.to/chat/6387ade9b0d6371309d1fc07/default" class="top-btn" target="_blank"><i class="fas fa-question-circle"></i><span>Support</span></a>
</div>

<div class="cards">

    <!-- ① Account Balance -->
    <div class="card c-balance">
        <div class="card-icon"><i class="fas fa-shield-alt"></i></div>
        <div class="card-lbl">Account Balance</div>
        <div class="card-amt"><span class="card-cur">ZMW</span><?= number_format($account_balance,2) ?></div>
        <div class="card-sub">
            <span class="dot" style="background:#FFD700"></span>
            Available to withdraw right now
        </div>
        <span class="card-badge"><i class="fas fa-arrow-up"></i> Withdraw</span>
    </div>

    <!-- ② Running Investment -->
    <div class="card c-running tap" onclick="location.href='myinvestment.php'">
        <div class="card-icon"><i class="fas fa-spinner fa-spin"></i></div>
        <div class="card-lbl">Running Investment</div>
        <div class="card-amt"><span class="card-cur">ZMW</span><?= number_format($running_investments,2) ?></div>
        <div class="card-sub">
            <span class="dot" style="background:#00e676"></span>
            <?= $running_count ?> active plan<?= $running_count !== 1 ? 's' : '' ?> &bull;
            Capital locked until maturity &bull; Tap to view
        </div>
        <span class="card-badge"><i class="fas fa-lock"></i> Locked</span>
    </div>

    <!-- ④ Daily Profits -->
    <div class="card c-daily tap" onclick="location.href='profits.php'">
        <div class="card-icon"><i class="fas fa-coins"></i></div>
        <div class="card-lbl">Daily Profits Earned</div>
        <div class="card-amt"><span class="card-cur">ZMW</span><?= number_format($daily_profits_earned,2) ?></div>
        <div class="card-sub">
            <span class="dot" style="background:#00b4ff"></span>
            From <strong style="color:#6ea8ff">Profit-Only</strong> plans &bull;
            Credited to your balance every day &bull; Tap for history
        </div>
        <span class="card-badge">Withdrawable</span>
    </div>

    <!-- ⑤ Matured Investments -->
    <div class="card c-matured tap" onclick="location.href='myinvestment.php'">
        <div class="card-icon"><i class="fas fa-check-circle"></i></div>
        <div class="card-lbl">Matured Investments</div>
        <div class="card-amt"><span class="card-cur">ZMW</span><?= number_format($matured_total,2) ?></div>
        <div class="card-sub">
            <span class="dot" style="background:#c8e600"></span>
            Completed plans &bull; Tap to view details
        </div>
        <span class="card-badge">Completed</span>
    </div>

    <!-- ⑥ Total Withdrawn -->
    <div class="card c-withdrawn">
        <div class="card-icon"><i class="fas fa-arrow-circle-up"></i></div>
        <div class="card-lbl">Total Withdrawn</div>
        <div class="card-amt"><span class="card-cur">ZMW</span><?= number_format($total_withdrawn,2) ?></div>
        <div class="card-sub">
            <span class="dot" style="background:#ff6464"></span>
            Approved and completed withdrawals only
        </div>
        <span class="card-badge">Paid Out</span>
    </div>

</div>

<script>
var navHome = document.querySelector('.nav-item[href="home.php"]');
if(navHome) navHome.classList.add('active');
</script>
<?php include 'bottom-nav.php'; ?>
</body>
</html>