<?php
session_start();

// Check if there's an admin session backup
if (isset($_SESSION['admin_session_backup'])) {
    // Restore admin session
    $_SESSION['admin_logged_in'] = $_SESSION['admin_session_backup']['admin_logged_in'];
    $_SESSION['admin_username'] = $_SESSION['admin_session_backup']['admin_username'];
    
    // Clear user session
    unset($_SESSION['user_id']);
    unset($_SESSION['admin_session_backup']);
    
    // Redirect to admin dashboard
    header("Location: admin_dashboard.php");
    exit();
} else {
    // No admin session found, redirect to admin login
    header("Location: admin_login.php");
    exit();
}
?>