<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
require_once 'db.php';

$user_id = $_SESSION['user_id'];
$success = '';
$error = '';

// Get current user data
$user_query = "SELECT * FROM users WHERE id='$user_id'";
$user_result = mysqli_query($conn, $user_query);
$user = mysqli_fetch_assoc($user_result);

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // Update Phone Number
    if (isset($_POST['update_phone'])) {
        $new_phone = mysqli_real_escape_string($conn, trim($_POST['phone_number']));
        
        if (empty($new_phone)) {
            $error = "Phone number cannot be empty";
        } else {
            // Check if phone already exists for another user
            $check_query = "SELECT id FROM users WHERE phone_number='$new_phone' AND id != '$user_id'";
            $check_result = mysqli_query($conn, $check_query);
            
            if (mysqli_num_rows($check_result) > 0) {
                $error = "This phone number is already registered";
            } else {
                $update_query = "UPDATE users SET phone_number='$new_phone' WHERE id='$user_id'";
                if (mysqli_query($conn, $update_query)) {
                    $success = "Phone number updated successfully";
                    $user['phone_number'] = $new_phone;
                } else {
                    $error = "Failed to update phone number";
                }
            }
        }
    }
    
    // Update Email
    if (isset($_POST['update_email'])) {
        $new_email = mysqli_real_escape_string($conn, trim($_POST['email']));
        
        if (empty($new_email)) {
            $error = "Email cannot be empty";
        } elseif (!filter_var($new_email, FILTER_VALIDATE_EMAIL)) {
            $error = "Invalid email format";
        } else {
            // Check if email already exists for another user
            $check_query = "SELECT id FROM users WHERE email='$new_email' AND id != '$user_id'";
            $check_result = mysqli_query($conn, $check_query);
            
            if (mysqli_num_rows($check_result) > 0) {
                $error = "This email is already registered";
            } else {
                $update_query = "UPDATE users SET email='$new_email' WHERE id='$user_id'";
                if (mysqli_query($conn, $update_query)) {
                    $success = "Email updated successfully";
                    $user['email'] = $new_email;
                } else {
                    $error = "Failed to update email";
                }
            }
        }
    }
    
    // Update Password
    if (isset($_POST['update_password'])) {
        $current_password = $_POST['current_password'];
        $new_password = $_POST['new_password'];
        $confirm_password = $_POST['confirm_password'];
        
        if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
            $error = "All password fields are required";
        } elseif (!password_verify($current_password, $user['password'])) {
            $error = "Current password is incorrect";
        } elseif (strlen($new_password) < 6) {
            $error = "New password must be at least 6 characters";
        } elseif ($new_password !== $confirm_password) {
            $error = "New passwords do not match";
        } else {
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $update_query = "UPDATE users SET password='$hashed_password' WHERE id='$user_id'";
            
            if (mysqli_query($conn, $update_query)) {
                $success = "Password updated successfully";
            } else {
                $error = "Failed to update password";
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - MaxTrade</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            background-color: #000;
            color: #fff;
            font-family: Arial, sans-serif;
            padding-bottom: 70px;
        }
        .header {
            background: #111;
            padding: 15px;
            display: flex;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.5);
        }
        .back-btn {
            background: none;
            border: none;
            color: #FFD700;
            font-size: 24px;
            cursor: pointer;
            margin-right: 15px;
        }
        .header h1 {
            color: #fff;
            font-size: 20px;
        }
        .container {
            padding: 15px;
        }
        .alert {
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 15px;
            font-size: 14px;
        }
        .alert-success {
            background: #1a4d1a;
            border: 1px solid #2d7a2d;
            color: #4ade80;
        }
        .alert-error {
            background: #4d1a1a;
            border: 1px solid #7a2d2d;
            color: #f87171;
        }
        .settings-section {
            background: #111;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.5);
        }
        .section-title {
            font-size: 18px;
            font-weight: bold;
            color: #FFD700;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-label {
            display: block;
            color: #888;
            font-size: 12px;
            margin-bottom: 5px;
        }
        .form-input {
            width: 100%;
            padding: 12px;
            background: #000;
            border: 1px solid #333;
            border-radius: 8px;
            color: #fff;
            font-size: 14px;
        }
        .form-input:focus {
            outline: none;
            border-color: #FFD700;
        }
        .current-value {
            background: #000;
            padding: 12px;
            border: 1px solid #333;
            border-radius: 8px;
            margin-bottom: 15px;
        }
        .current-label {
            color: #888;
            font-size: 11px;
            margin-bottom: 5px;
        }
        .current-text {
            color: #fff;
            font-size: 14px;
        }
        .update-btn {
            width: 100%;
            padding: 12px;
            background: #FFD700;
            color: #000;
            border: none;
            border-radius: 8px;
            font-weight: bold;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s;
        }
        .update-btn:hover {
            background: #FFA500;
        }
        .divider {
            height: 1px;
            background: #333;
            margin: 20px 0;
        }
        .password-toggle {
            position: relative;
        }
        .toggle-icon {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            font-size: 18px;
            user-select: none;
        }
        .info-text {
            font-size: 11px;
            color: #666;
            margin-top: 5px;
        }
    </style>
</head>
<body>
    <div class="header">
        <button class="back-btn" onclick="window.location.href='profile.php'">←</button>
        <h1>Account Settings</h1>
    </div>

    <div class="container">
        <?php if ($success): ?>
            <div class="alert alert-success">✓ <?php echo $success; ?></div>
        <?php endif; ?>
        
        <?php if ($error): ?>
            <div class="alert alert-error">✗ <?php echo $error; ?></div>
        <?php endif; ?>

        <!-- Phone Number Section -->
        <div class="settings-section">
            <div class="section-title">📱 Phone Number</div>
            
            <div class="current-value">
                <div class="current-label">Current Phone Number</div>
                <div class="current-text"><?php echo $user['phone_number']; ?></div>
            </div>

            <form method="POST" action="">
                <div class="form-group">
                    <label class="form-label">New Phone Number</label>
                    <input type="tel" name="phone_number" class="form-input" placeholder="Enter new phone number" required>
                </div>
                <button type="submit" name="update_phone" class="update-btn">Update Phone Number</button>
            </form>
        </div>

        <!-- Email Section -->
        <div class="settings-section">
            <div class="section-title">📧 Email Address</div>
            
            <div class="current-value">
                <div class="current-label">Current Email</div>
                <div class="current-text"><?php echo $user['email']; ?></div>
            </div>

            <form method="POST" action="">
                <div class="form-group">
                    <label class="form-label">New Email Address</label>
                    <input type="email" name="email" class="form-input" placeholder="Enter new email address" required>
                </div>
                <button type="submit" name="update_email" class="update-btn">Update Email</button>
            </form>
        </div>

        <!-- Password Section -->
        <div class="settings-section">
            <div class="section-title">🔒 Password</div>
            
            <form method="POST" action="">
                <div class="form-group">
                    <label class="form-label">Current Password</label>
                    <div class="password-toggle">
                        <input type="password" name="current_password" id="current_password" class="form-input" placeholder="Enter current password" required>
                        <span class="toggle-icon" onclick="togglePassword('current_password')">👁️</span>
                    </div>
                </div>

                <div class="divider"></div>

                <div class="form-group">
                    <label class="form-label">New Password</label>
                    <div class="password-toggle">
                        <input type="password" name="new_password" id="new_password" class="form-input" placeholder="Enter new password" required>
                        <span class="toggle-icon" onclick="togglePassword('new_password')">👁️</span>
                    </div>
                    <div class="info-text">Must be at least 6 characters</div>
                </div>

                <div class="form-group">
                    <label class="form-label">Confirm New Password</label>
                    <div class="password-toggle">
                        <input type="password" name="confirm_password" id="confirm_password" class="form-input" placeholder="Confirm new password" required>
                        <span class="toggle-icon" onclick="togglePassword('confirm_password')">👁️</span>
                    </div>
                </div>

                <button type="submit" name="update_password" class="update-btn">Update Password</button>
            </form>
        </div>
    </div>

    <script>
        function togglePassword(fieldId) {
            const field = document.getElementById(fieldId);
            if (field.type === 'password') {
                field.type = 'text';
            } else {
                field.type = 'password';
            }
        }

        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                alert.style.transition = 'opacity 0.5s';
                alert.style.opacity = '0';
                setTimeout(function() {
                    alert.remove();
                }, 500);
            });
        }, 5000);
    </script>

    <?php include 'bottom-nav.php'; ?>
</body>
</html>